local assets =
{
    Asset("ANIM", "anim/slurtle_shellpieces.zip"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("slurtle_shellpieces")
    inst.AnimState:SetBuild("slurtle_shellpieces")
    inst.AnimState:PlayAnimation("idle")

    MakeInventoryFloatable(inst, "med", nil, 0.75)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("repairer")
    inst.components.repairer.repairmaterial = MATERIALS.SHELL
    inst.components.repairer.healthrepairvalue = TUNING.REPAIR_SHELL_HEALTH

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("slurtle_shellpieces", fn, assets)